import 'dart:convert';
import 'package:flutter/cupertino.dart';
import 'package:flutter_facebook_auth/flutter_facebook_auth.dart';
import 'package:get/get.dart';
import 'package:google_sign_in/google_sign_in.dart';
import 'package:play_lab/constants/constant_helper.dart';
import 'package:play_lab/constants/my_strings.dart';
import 'package:play_lab/data/model/auth/login_response_model.dart';

import 'package:play_lab/data/model/global/response_model/response_model.dart';
import 'package:play_lab/view/components/show_custom_snackbar.dart';

import '../../../core/helper/shared_pref_helper.dart';
import '../../../core/route/route.dart';
import '../../repo/auth/login_repo.dart';

class LoginController extends GetxController {
  LoginRepo loginRepo;

  final FocusNode emailFocusNode = FocusNode();
  final FocusNode passwordFocusNode = FocusNode();

  TextEditingController emailController = TextEditingController();
  TextEditingController passwordController = TextEditingController();

  List<String> errors = [];
  String? email;
  String? password;
  bool isLoading = false;
  bool remember = true;

  LoginController({required this.loginRepo});

  void forgetPassword() {
    Get.toNamed(RouteHelper.forgetPasswordScreen);
  }

  void checkAndGotoNextStep(LoginResponseModel responseModel) async {
    isLoading = true;
    update();

    bool needEmailVerification = responseModel.data?.user?.ev.toString() == "0" ? true : false;
    bool needSmsVerification = responseModel.data?.user?.sv.toString() == '0' ? true : false;

    String expDate = responseModel.data?.user?.exp ?? '';

    loginRepo.apiClient.storeExpiredDate(expDate);

    await loginRepo.apiClient.sharedPreferences.setBool(SharedPreferenceHelper.rememberMeKey, true);
    await loginRepo.apiClient.sharedPreferences.setString(SharedPreferenceHelper.accessTokenKey, responseModel.data?.accessToken ?? '');
    await loginRepo.apiClient.sharedPreferences.setString(SharedPreferenceHelper.accessTokenType, responseModel.data?.tokenType ?? '');
    await loginRepo.apiClient.sharedPreferences.setString(SharedPreferenceHelper.userEmailKey, responseModel.data?.user?.email ?? '');
    await loginRepo.apiClient.sharedPreferences.setString(SharedPreferenceHelper.userIDKey, responseModel.data?.user?.id.toString() ?? '');
    await loginRepo.apiClient.sharedPreferences.setString(SharedPreferenceHelper.phoneNumberKey, responseModel.data?.user?.mobile ?? '');
    await loginRepo.apiClient.sharedPreferences.setString(SharedPreferenceHelper.userNameKey, responseModel.data?.user?.username ?? '');
    await loginRepo.apiClient.sharedPreferences.setString(SharedPreferenceHelper.userImageKey, responseModel.data?.user?.image ?? '');
    await loginRepo.apiClient.sharedPreferences.setString(SharedPreferenceHelper.userFullNameKey, '${responseModel.data?.user?.firstName ?? ''} ${responseModel.data?.user?.lastName ?? ''}');

    bool isProfileCompleteEnable = responseModel.data?.user?.profileComplete == '0' ? true : false;
    if (isProfileCompleteEnable) {
      Get.offAndToNamed(RouteHelper.profileComplete);
    } else if (needEmailVerification) {
      Get.offAndToNamed(RouteHelper.emailVerificationScreen);
    } else if (needSmsVerification) {
      Get.offAndToNamed(RouteHelper.smsVerificationScreen);
    } else {
      await loginRepo.sendUserToken();
      Get.offAndToNamed(RouteHelper.homeScreen);
    }

    if (remember) {
      changeRememberMe();
    }

    isLoading = false;
    update();
  }

  void loginUser() async {
    isLoading = true;
    update();

    ResponseModel model = await loginRepo.loginUser(emailController.text, passwordController.text);

    if (model.statusCode == 200) {
      LoginResponseModel loginModel = LoginResponseModel.fromJson(jsonDecode(model.responseJson));
      if (loginModel.status == 'error') {
        CustomSnackbar.showCustomSnackbar(errorList: loginModel.message?.error ?? ['user login failed , pls try again'], msg: [], isError: true);
      } else {
        checkAndGotoNextStep(loginModel);
      }
    } else {
      CustomSnackbar.showCustomSnackbar(errorList: [model.message], msg: [], isError: false);
    }

    isLoading = false;
    update();
  }

  changeRememberMe() {
    remember = !remember;
    update();
  }

  rememberMe() async {
    await loginRepo.apiClient.sharedPreferences.setBool(SharedPreferenceHelper.rememberMeKey, true);
  }

  void clearAllSharedData() {
    loginRepo.apiClient.sharedPreferences.setBool(SharedPreferenceHelper.rememberMeKey, false);
    loginRepo.apiClient.sharedPreferences.setString(SharedPreferenceHelper.accessTokenKey, '');
    return;
  }

  bool isAllSocialAuthDisable() {
    bool isFbAuthEnable = loginRepo.apiClient.isFacebookAuthEnable();
    bool isGmailAuthEnable = loginRepo.apiClient.isGmailAuthEnable();
    bool isLinkedinAuthEnable = loginRepo.apiClient.isLinkedinAuthEnable();

    if (!isFbAuthEnable && !isGmailAuthEnable && !isLinkedinAuthEnable) {
      return true;
    } else {
      return false;
    }
  }

  bool isSingleSocialAuthEnable({bool isGoogle = false}) {
    bool isEnable = isGoogle ? loginRepo.apiClient.isGmailAuthEnable() : loginRepo.apiClient.isFacebookAuthEnable();
    return isEnable;
  }
}
